implementation module receiverhandle


//	Clean Object I/O library, version 1.1


import	StdBool, StdInt, StdList
import	receivermessage
import	ostoolbox

::	ReceiverHandles ps
	=	{	rReceivers	:: [ReceiverStateHandle ps]
		}
::	ReceiverStateHandle ps
	=	E..ls:
		{	rState		:: ls							// The local state of the receiver
		,	rHandle		:: ReceiverHandle ls ps			// The receiver handle
		}
::	ReceiverHandle ls ps
	=	E.m r:
		{	rId			:: Id							// The id of the receiver
		,	rASMQ		:: [m]							// The asynchronous message queue of the receiver
		,	rSelect		:: SelectState					// The current SelectState of the receiver
		,	rOneWay		:: Bool							// Flag: True iff receiver is uni-directional
		,	rFun		:: RHandleFunction ls m r ps	// If rOneWay then [r]==[], otherwise [r]==[_]
		,	rInetInfo	:: !Maybe !(!EndpointRef`,!InetReceiverCategory`,!Int,!IdFun !*OSToolbox)
														// For internet receivers
		,	rConnected	:: ![!Id]						// storing the argument of the ReceiverCloseAlsoReceivers attribute
		}
::	RHandleFunction ls m r ps
	:==	m -> (ls,ps) -> (ls,[r],ps)

::	InetReceiverASMQType	:== (!InetEvent`,!EndpointRef`,!Int)

::	InetEvent`				:== Int
::	EndpointRef`			:==	Int
::	InetReceiverCategory`	:==	Int

/*	Conversion functions:
	Cast contains abc code because it can't be typed conventionally.
	The function Cast is required to break the Existential Type abstraction needed
	for message passing. (JVG/RWS)
*/
Cast :: !a -> b
Cast a
	=	code
		{
			pop_a 0
		}

receiverIdentified :: !Id !(ReceiverHandle .ls .ps) -> Bool
receiverIdentified id {rId}
	=	id==rId

inetReceiverIdentified		::	!(!EndpointRef`, !InetReceiverCategory`)
								!(ReceiverHandle .ls .ps)	-> Bool
inetReceiverIdentified _ {rInetInfo=Nothing}
	= False
inetReceiverIdentified (epR1,type1) {rInetInfo=Just (epR2,type2,_,_)}
	= epR1==epR2 && type1==type2

inetReceiverIdentifiedWithId	::	!(!Id, !InetReceiverCategory`)
									!(ReceiverHandle .ls .ps)	-> Bool
inetReceiverIdentifiedWithId _ {rInetInfo=Nothing}
	= False
inetReceiverIdentifiedWithId (id,category) {rId, rInetInfo=Just (_,rCategory,_,_)}
	= id==rId && category==rCategory

receiverSetSelectState :: !SelectState !(ReceiverStateHandle .ps) -> ReceiverStateHandle .ps
receiverSetSelectState select rsH=:{rHandle=rH}
	=	{rsH & rHandle={rH & rSelect=select}}

receiverSetFunction :: !Id (RHandleFunction .ls m r .ps) !(ReceiverStateHandle .ps) -> ReceiverStateHandle .ps
receiverSetFunction id f rsH=:{rHandle=rH}
	|	receiverIdentified id rH
		=	{rsH & rHandle={rH & rFun=f}}
		=	rsH

receiverHandleSyncMessage :: !(SyncMessage m r) !(ReceiverHandle .ls .ps) (.ls,.ps)
										  -> ([r],ReceiverHandle .ls .ps, (.ls,.ps))
receiverHandleSyncMessage {smRecLoc={rlReceiverId},smMsg} rH=:{rFun} context
	|	not (receiverIdentified rlReceiverId rH)
		=	([],rH,context)
	|	otherwise
		#	(ls,resp,ps)	= rFun (Cast smMsg) context
		=	(Cast resp,rH,(ls,ps))

receiverAddASyncMessage :: !Id m !(ReceiverHandle .ls .ps) -> ReceiverHandle .ls .ps
receiverAddASyncMessage id msg rH=:{rASMQ}
	|	receiverIdentified id rH
		=	{rH & rASMQ=rASMQ++[Cast msg]}
	|	otherwise
		=	rH

receiverApplyInetEvent		::	!InetReceiverASMQType !(ReceiverHandle .ls .ps) (.ls,.ps)
							->	(.ls,.ps)
receiverApplyInetEvent eventInfo rH=:{rFun,rInetInfo=Just _} context
	# (ls,_,ps)	= rFun (Cast eventInfo) context
	= (ls,ps)

getInetReceiverRId			::	!(ReceiverHandle .ls .ps)	-> (RId InetReceiverASMQType)
// converts an Id into an RId
getInetReceiverRId {rId}
	= toRId (fromId rId)
